/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.versions;

import com.endertech.common.CommonArray;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.versions.GameVersions;
import java.util.EnumMap;

public class ForgeJoiner {
    private Delimiter delimiter;
    private final EnumMap<GameVersions, String[]> mapWords = new EnumMap(GameVersions.class);

    public ForgeJoiner(String ... words) {
        this(Delimiter.none(), words);
    }

    public ForgeJoiner(Delimiter delimiter, String ... words) {
        this.delimiter = delimiter;
        for (GameVersions version : GameVersions.values()) {
            this.mapWords.put(version, words);
        }
    }

    public static ForgeJoiner withRegNameDelimiters(String ... words) {
        return new ForgeJoiner(Delimiter.regName(), words);
    }

    public ForgeJoiner withDelimiter(Delimiter delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public ForgeJoiner setFor(GameVersions version, String ... words) {
        this.mapWords.put(version, words);
        return this;
    }

    public ForgeJoiner oreDictFormatFor(GameVersions version) {
        this.capitalizeWordsFor(version);
        String[] words = this.mapWords.get((Object)version);
        if (words.length > 0) {
            words[0] = CommonString.decapitalizeFirstChar(words[0]);
        }
        this.delimiter.setFor(version, "");
        return this;
    }

    public ForgeJoiner reverseWordsOrderFor(GameVersions version) {
        String[] words = this.mapWords.get((Object)version);
        CommonArray.reverse(words);
        return this;
    }

    public ForgeJoiner capitalizeWordsFor(GameVersions version) {
        String[] words = this.mapWords.get((Object)version);
        this.mapWords.put(version, UnitId.capitalizeWords(words));
        return this;
    }

    public Delimiter getDelimiter() {
        return this.delimiter;
    }

    protected String toString(GameVersions version) {
        String delimiter = this.delimiter.toString(version);
        String[] words = this.mapWords.get((Object)version);
        return UnitId.joinWords(delimiter, words);
    }

    public String toString() {
        return this.toString(GameVersions.getCurrent());
    }

    public static class Delimiter {
        public static final String NONE = "";
        public static final String REG_NAME = "_";
        private final EnumMap<GameVersions, String> mapDelimiters = new EnumMap(GameVersions.class);

        public Delimiter(String delimiter) {
            for (GameVersions version : GameVersions.values()) {
                this.mapDelimiters.put(version, delimiter);
            }
        }

        public static Delimiter none() {
            return new Delimiter(NONE);
        }

        public static Delimiter regName() {
            return new Delimiter(REG_NAME);
        }

        public Delimiter setFor(GameVersions version, String delimiter) {
            this.mapDelimiters.put(version, delimiter);
            return this;
        }

        public Delimiter setForOlderThan(GameVersions version, String delimiter) {
            for (GameVersions ver : GameVersions.values()) {
                if (ver.ordinal() >= version.ordinal() || ver == GameVersions.DEFAULT) continue;
                this.setFor(ver, delimiter);
            }
            return this;
        }

        public Delimiter setForNewerThan(GameVersions version, String delimiter) {
            for (GameVersions ver : GameVersions.values()) {
                if (ver.ordinal() <= version.ordinal() || ver == GameVersions.DEFAULT) continue;
                this.setFor(ver, delimiter);
            }
            return this;
        }

        public Delimiter setNoneFor(GameVersions version) {
            return this.setFor(version, NONE);
        }

        protected String toString(GameVersions version) {
            return this.mapDelimiters.get((Object)version);
        }

        public String toString() {
            return this.toString(GameVersions.getCurrent());
        }
    }
}

